//================================================================================
// AMLPFunRifle, for the AMLP Fun server.
// website: www.amlp.info
// contact: skaarj@amlp.info & thedane@amlp.info
//================================================================================
class FunRifle_AMLP expands TournamentWeapon;

#exec TEXTURE IMPORT NAME=MainCrosshair FILE=Textures\MainCrosshair.pcx FLAGS=2 MIPS=OFF
#exec TEXTURE IMPORT NAME=AMLPCross FILE=Textures\AMLPCross.pcx FLAGS=2 MIPS=OFF

#exec AUDIO IMPORT FILE="Sounds\SniperFire.wav" NAME="SniperFire" GROUP="Rifle"
#exec AUDIO IMPORT FILE="Sounds\FunPickup.wav" NAME="FunPickup" GROUP="Rifle"

#exec TEXTURE IMPORT NAME=FunRifle2a FILE=Textures\FunRifle2a.pcx GROUP=Rifle
#exec TEXTURE IMPORT NAME=FunRifle2b FILE=Textures\FunRifle2b.pcx GROUP=Rifle

var int NumFire;
var name FireAnims[5];
var vector OwnerLocation;
var float StillTime, StillStart;
var bool bZoom;

simulated function PostRender( canvas Canvas )
{
	local PlayerPawn P;
	local float Scale;
	local float Size;

	local float Xlength;
	local float range;
	local vector HitLocation, HitNormal, StartTrace, EndTrace, X,Y,Z;
   	local actor Other;
	local float radpitch;

	Super.PostRender(Canvas);
	P = PlayerPawn(Owner);
	Size = 256;

	if ( (P != None) && (P.DesiredFOV != P.DefaultFOV) )
	{
		bOwnsCrossHair = true;

		if ( Level.bHighDetailMode )
		{
			Canvas.Style = ERenderStyle.STY_Modulated;

			Canvas.Style = ERenderStyle.STY_Translucent;		}
		else
			Canvas.Style = ERenderStyle.STY_Normal;
			Scale = 1;
			Canvas.SetPos(0.5 * Canvas.ClipX - Size/2 * Scale, 0.5 * Canvas.ClipY - Size/2 * Scale );
			if ( Level.bHighDetailMode )
				Canvas.Style = ERenderStyle.STY_Translucent;
			else
				Canvas.Style = ERenderStyle.STY_Normal;
				Canvas.DrawIcon(Texture'MainCrosshair', Scale);

		// Top Line
		Canvas.SetPos( Canvas.ClipX/2, Canvas.ClipY/2-Size*2 + (Size/2*3-P.DesiredFOV/2*3) + 10);
		Canvas.DrawTile( Texture'AMLPCross', 1, Size/2, 64, 2, 0, 63 );

		// Bottom Line
		Canvas.SetPos( Canvas.ClipX/2, Canvas.ClipY/2 + Size+Size/2 -(Size/2*3-P.DesiredFOV/2*3)+1 -10);
		Canvas.DrawTile( Texture'AMLPCross', 1, Size/2, 64, 64, 0, 63 );

		// Left Line
		Canvas.SetPos( Canvas.ClipX/2 - Size*2 +(Size/2*3-P.DesiredFOV/2*3) +10 , Canvas.ClipY/2-1 );
		Canvas.DrawTile( Texture'AMLPCross', Size/2, 1, 2, 64, 63, 0 );

		// Right Line
		Canvas.SetPos( Canvas.ClipX/2 + Size+Size/2 - (Size/2*3-P.DesiredFOV/2*3)+1 -10 , Canvas.ClipY/2-1 );
		Canvas.DrawTile( Texture'AMLPCross', Size/2, 1, 65, 64, 63, 0 );

	        // Calc range
        	XLength=255.0;
		GetAxes(Pawn(owner).ViewRotation,X,Y,Z);
		if ((Pawn(Owner).ViewRotation.Pitch >= 0) && (Pawn(Owner).ViewRotation.Pitch <= 18000))
			radpitch = float(Pawn(Owner).ViewRotation.Pitch) / float(182) * (Pi/float(180));
		else
			radpitch = float(Pawn(Owner).ViewRotation.Pitch - 65535) / float(182) * (Pi/float(180));

		StartTrace = Owner.Location + Pawn(Owner).EyeHeight*Z*cos(radpitch);
	    	AdjustedAim = pawn(owner).AdjustAim(1000000, StartTrace, 2.75*AimError, False, False);
		EndTrace = StartTrace +(20000 * vector(AdjustedAim));
		Other = Pawn(Owner).TraceShot(HitLocation,HitNormal,EndTrace,StartTrace);
		range = Vsize(StartTrace-HitLocation)/48-0.25;

        Scale = Canvas.ClipX/640;
    	//draw a text under the scope.
		Canvas.SetPos(0.5 * Canvas.ClipX - 70 * Scale * 0.5, 0.5 * Canvas.ClipY + 147 * Scale * 0.5);
        Canvas.Font = Font'Engine.MedFont';
        Canvas.DrawColor.R = 0;
		Canvas.DrawColor.G = 0;
		Canvas.DrawColor.B = 0;
		Scale = P.DefaultFOV/P.DesiredFOV;
		Canvas.DrawText("");

		// Magnification Display
		Canvas.SetPos( Canvas.ClipX/2 + Size/2 -20, Canvas.ClipY/2 +Size/2 -20 );
		Canvas.Font = Font'Botpack.WhiteFont';
		Canvas.DrawColor.R = 50;
		Canvas.DrawColor.G = 50;
		Canvas.DrawColor.B = 50;
		Scale = P.DefaultFOV/P.DesiredFOV;
		Canvas.DrawText("x"$int(Scale)$"."$int(10 * Scale - 10 * int(Scale))$"");

	}
	else
		bOwnsCrossHair = false;
}



function float RateSelf( out int bUseAltMode )
{
	local float dist;

	if ( AmmoType.AmmoAmount <=0 )
		return -2;

	bUseAltMode = 0;
	if ( (Bot(Owner) != None) && Bot(Owner).bSniping )
		return AIRating + 1.15;
	if (  Pawn(Owner).Enemy != None )
	{
		dist = VSize(Pawn(Owner).Enemy.Location - Owner.Location);
		if ( dist > 1200 )
		{
			if ( dist > 2000 )
				return (AIRating + 0.75);
			return (AIRating + FMin(0.0001 * dist, 0.45));
		}
	}
	return AIRating;
}

// set which hand is holding weapon
function setHand(float Hand)
{
	Super.SetHand(Hand);
	if ( Hand == 1 )
		Mesh = mesh(DynamicLoadObject("Botpack.Rifle2mL", class'Mesh'));
	else
		Mesh = mesh'Rifle2m';
}

function DropFrom(vector StartLocation)
{
	Destroy();
}

simulated function PlayFiring()
{
	local int r;

	PlayOwnedSound(FireSound, SLOT_None, Pawn(Owner).SoundDampening*3.0);
	if ( (Owner.Physics != PHYS_Falling && Owner.Physics != PHYS_Swimming && Pawn(Owner).bDuck != 0)
	   || Owner.Velocity == 0 * Owner.Velocity )
		PlayAnim(FireAnims[/*Rand(5)*/4],3 + 3 * FireAdjust, 0.05);
	else
		PlayAnim(FireAnims[Rand(5)],0.3 + 0.3 * FireAdjust, 0.05);

	if ( (PlayerPawn(Owner) != None)
		&& (PlayerPawn(Owner).DesiredFOV == PlayerPawn(Owner).DefaultFOV) )
		bMuzzleFlash++;
}

simulated function bool ClientAltFire( float Value )
{
	GotoState('Zooming');
	return true;
}

function AltFire( float Value )
{
	ClientAltFire(Value);
}

function Fire( float Value )
{
	if ( (AmmoType == None) && (AmmoName != None) )
	{
		// ammocheck
		GiveAmmo(Pawn(Owner));
	}
	if ( AmmoType.UseAmmo(1) )
	{
		GotoState('NormalFire');
		bPointing=True;
		bCanClientFire = true;
		ClientFire(Value);
		if ( bRapidFire || (FiringSpeed > 0) )
			Pawn(Owner).PlayRecoil(FiringSpeed);
		if ( bInstantHit )
		{
			if ( (Owner.Physics != PHYS_Falling && Owner.Physics != PHYS_Swimming && Pawn(Owner).bDuck != 0)
			   || Owner.Velocity == 0 * Owner.Velocity )
				TraceFire(0.0);
			else
				TraceFire(16);
		}
		else
			ProjectileFire(ProjectileClass, ProjectileSpeed, bWarnTarget);
	}
}

///////////////////////////////////////////////////////
state NormalFire
{
	function EndState()
	{
		Super.EndState();
		OldFlashCount = FlashCount;
	}

Begin:
		FlashCount++;
}

function Timer()
{
	local actor targ;
	local float bestAim, bestDist;
	local vector FireDir;
	local Pawn P;

	bestAim = 0.95;
	P = Pawn(Owner);
	if ( P == None )
	{
		GotoState('');
		return;
	}
	if ( VSize(P.Location - OwnerLocation) < 6 )
		StillTime += FMin(2.0, Level.TimeSeconds - StillStart);

	else
		StillTime = 0;
	StillStart = Level.TimeSeconds;
	OwnerLocation = P.Location;
	FireDir = vector(P.ViewRotation);
	targ = P.PickTarget(bestAim, bestDist, FireDir, Owner.Location);
	if ( Pawn(targ) != None )
	{
		SetTimer(1 + 4 * FRand(), false);
		bPointing = true;
		Pawn(targ).WarnTarget(P, 200, FireDir);
	}
	else
	{
		SetTimer(0.4 + 1.6 * FRand(), false);
		if ( (P.bFire == 0) && (P.bAltFire == 0) )
			bPointing = false;
	}
}

function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
	local vector v;
	local int i;
	local BloodDrop b;

	if (Other == Level)
		Spawn(class'UT_HeavyWallHitEffect',,, HitLocation+HitNormal, Rotator(HitNormal));
	else if ( (Other != self) && (Other != Owner) && (Other != None) )
	{
		if ( Other.bIsPawn )
		{
			Other.PlaySound(Sound 'ChunkHit',, 4.0,,100);
			Other.PlaySound(Sound 'UnrealI.Razorjack.BladeThunk',, 4.0,,100);
			PlayOwnedSound(Sound 'UnrealI.Razorjack.BladeThunk',, 4.0,,10);
		}
		if ( Other.bIsPawn && (HitLocation.Z - Other.Location.Z > 0.62 * Other.CollisionHeight)
		&& (instigator.IsA('PlayerPawn') || (instigator.IsA('Bot') && !Bot(Instigator).bNovice))
		&& ((Owner.Physics != PHYS_Falling && Owner.Physics != PHYS_Swimming && Pawn(Owner).bDuck != 0)
		|| Owner.Velocity == 0 * Owner.Velocity) )
		{
			if ( Pawn(Other).Health > 0 )
			{
				Other.TakeDamage(100000, Pawn(Owner), HitLocation, 35000 * X, AltDamageType);

				if ( Pawn(Other).Health < 1 )
				{
					AmmoType.AddAmmo(3);
					Spawn(class'UT_BigBloodHit',,, HitLocation);

					for (i=0; i<(6); i++)
					{
						v = HitLocation;
						v.X += 10 * FRand();
						v.X -= 15 * FRand();
						v.Y += 10 * FRand();
						v.Y -= 15 * FRand();
						v.Z += 10 * FRand();
						v.Z -= 15 * FRand();
						Spawn(class'UT_BloodHit',,, v);
					}

					for (i=0; i<(3); i++)
					{
						v = HitLocation;
						v.X += 5 * FRand();
						v.X -= 7 * FRand();
						v.Y += 5 * FRand();
						v.Y -= 7 * FRand();
						v.Z += 5 * FRand();
						v.Z -= 7 * FRand();
						Spawn(class'BloodBurst',,, v);

						v = HitLocation;
						v.X += 7 * FRand();
						v.X -= 10 * FRand();
						v.Y += 7 * FRand();
						v.Y -= 10 * FRand();
						v.Z += 7 * FRand();
						v.Z -= 10 * FRand();
						Spawn(class'BloodBurst',,, v);
					}

					for (i=0; i<(80); i++)
					{
						b = Spawn(class'BloodDrop',,, HitLocation);
						b.Velocity = vector( RotRand() ) * ( FRand() * 200 );
						b.DrawScale *= 2 * Frand();
					}

					for (i=0; i<80; i++)
					{
						b = Spawn(class'BloodDrop',,, HitLocation);
						b.Velocity.Z = i * 5;
						b.Velocity.X += (i / 7) * FRand();
						b.Velocity.X -= (i * 1.5 / 7) * FRand();
						b.Velocity.Y += (i / 7) * FRand();
						b.Velocity.Y -= (i * 1.5 / 7) * FRand();
						b.DrawScale += i * 0.00375 * FRand();
						b.bDecal = False;
					}
				}
			}
			else
				Other.TakeDamage(100000, Pawn(Owner), HitLocation, 35000 * X, AltDamageType);
		}
		else
			Other.TakeDamage(45,  Pawn(Owner), HitLocation, 30000.0*X, MyDamageType);

		if ( !Other.bIsPawn && !Other.IsA('Carcass') )
			spawn(class'UT_SpriteSmokePuff',,,HitLocation+HitNormal*9);
	}
}

function Finish()
{
	if ( (Pawn(Owner).bFire!=0) && (FRand() < 0.6) )
		Timer();
	Super.Finish();
}

function TraceFire( float Accuracy )
{
	local vector HitLocation, HitNormal, StartTrace, EndTrace, X,Y,Z;
	local actor Other;
	local Pawn PawnOwner;

	PawnOwner = Pawn(Owner);

	Owner.MakeNoise(PawnOwner.SoundDampening);
	GetAxes(PawnOwner.ViewRotation,X,Y,Z);
	StartTrace = Owner.Location + PawnOwner.Eyeheight * Z;
	AdjustedAim = PawnOwner.AdjustAim(1000000, StartTrace, 2*AimError, False, False);
	EndTrace = StartTrace + Accuracy * (FRand() - 0.5 )* Y * 1000
		+ Accuracy * (FRand() - 0.5 ) * Z * 1000;
	X = vector(AdjustedAim);
	EndTrace += (100000 * X);
	Other = PawnOwner.TraceShot(HitLocation,HitNormal,EndTrace,StartTrace);
	ProcessTraceHit(Other, HitLocation, HitNormal, X,Y,Z);
}


state Idle
{
	function Fire( float Value )
	{
		if ( AmmoType == None )
		{
			// ammocheck
			GiveAmmo(Pawn(Owner));
		}
		if (AmmoType.UseAmmo(1))
		{
			GotoState('NormalFire');
			bCanClientFire = true;
			bPointing=True;
			if ( Owner.IsA('Bot') )
			{
				// simulate bot using zoom
				if ( Bot(Owner).bSniping && (FRand() < 0.65) )
					AimError = AimError/FClamp(StillTime, 1.0, 8.0);
				else if ( VSize(Owner.Location - OwnerLocation) < 6 )
					AimError = AimError/FClamp(0.5 * StillTime, 1.0, 3.0);
				else
					StillTime = 0;
			}
			Pawn(Owner).PlayRecoil(FiringSpeed);
			if ( (Owner.Physics != PHYS_Falling && Owner.Physics != PHYS_Swimming && Pawn(Owner).bDuck != 0)
			   || Owner.Velocity == 0 * Owner.Velocity )
				TraceFire(0.0);
			else
				TraceFire(16);
			AimError = Default.AimError;
			ClientFire(Value);
		}
	}


	function BeginState()
	{
		bPointing = false;
		SetTimer(0.4 + 1.6 * FRand(), false);
		Super.BeginState();
	}

	function EndState()
	{
		SetTimer(0.0, false);
		Super.EndState();
	}

Begin:
	bPointing=False;
	if ( AmmoType.AmmoAmount<=0 )
		Pawn(Owner).SwitchToBestWeapon();  //Goto Weapon that has Ammo
	if ( Pawn(Owner).bFire!=0 ) Fire(0.0);
	Disable('AnimEnd');
	PlayIdleAnim();
}

///////////////////////////////////////////////////////
state Zooming
{
	simulated function Tick(float DeltaTime)
	{
		if ( Pawn(Owner).bAltFire == 0 )
		{
			bZoom = false;
			SetTimer(0.0,False);
			GoToState('Idle');
		}
		else if ( bZoom )
		{
			if ( PlayerPawn(Owner).DesiredFOV > 5 )
			{
				PlayerPawn(Owner).DesiredFOV -= PlayerPawn(Owner).DesiredFOV*DeltaTime*3.0;
			}

			if ( PlayerPawn(Owner).DesiredFOV <=5 )
			{
				PlayerPawn(Owner).DesiredFOV = 5;
				bZoom = false;
				SetTimer(0.0,False);
				GoToState('Idle');
			}
		}
	}

	simulated function BeginState()
	{
		if ( Owner.IsA('PlayerPawn') )
		{
			if ( PlayerPawn(Owner).DesiredFOV == PlayerPawn(Owner).DefaultFOV )
			{
				bZoom = true;
				SetTimer(0.2,True);
			}
			else if ( bZoom == false )
			{
				PlayerPawn(Owner).DesiredFOV = PlayerPawn(Owner).DefaultFOV;
				Pawn(Owner).bAltFire = 0;
			}
		}
		else
		{
			Pawn(Owner).bFire = 1;
			Pawn(Owner).bAltFire = 0;
			Global.Fire(0);
		}
	}
}

///////////////////////////////////////////////////////////
simulated function PlayIdleAnim()
{
	if ( Mesh != PickupViewMesh )
		PlayAnim('Still',1.0, 0.05);
}

